let currentMonth = new Date().getMonth();
let currentYear = new Date().getFullYear();

document.addEventListener('DOMContentLoaded', () => {
    loadCalendar(currentMonth, currentYear);

    document.getElementById('bookingForm').addEventListener('submit', function(e) {
        e.preventDefault();
        submitBooking();
    });
});

function changeMonth(delta) {
    currentMonth += delta;
    if (currentMonth > 11) {
        currentMonth = 0;
        currentYear++;
    } else if (currentMonth < 0) {
        currentMonth = 11;
        currentYear--;
    }
    loadCalendar(currentMonth, currentYear);
}

function loadCalendar(month, year) {
    const monthNames = ["January", "February", "March", "April", "May", "June",
        "July", "August", "September", "October", "November", "December"];
    document.getElementById('month-year').textContent = `${monthNames[month]} ${year}`;

    const firstDay = new Date(year, month, 1).getDay();
    const daysInMonth = new Date(year, month + 1, 0).getDate();

    const calendar = document.getElementById('calendar');
    calendar.innerHTML = "";

    for (let i = 0; i < firstDay; i++) {
        calendar.appendChild(document.createElement('div'));
    }

    fetch('fetch_bookings.php')
        .then(response => response.json())
        .then(data => {
            for (let day = 1; day <= daysInMonth; day++) {
                const dateStr = `${year}-${(month + 1).toString().padStart(2, '0')}-${day.toString().padStart(2, '0')}`;
                const dayDiv = document.createElement('div');
                dayDiv.className = 'day';
                dayDiv.textContent = day;

                if (data.includes(dateStr)) {
                    dayDiv.classList.add('booked');
                } else {
                    dayDiv.addEventListener('click', () => selectDate(dateStr));
                }

                if (new Date().toDateString() === new Date(year, month, day).toDateString()) {
                    dayDiv.classList.add('today');
                }

                calendar.appendChild(dayDiv);
            }
        });
}

function selectDate(dateStr) {
    document.getElementById('bookingDate').value = dateStr;
}

function submitBooking() {
    const formData = new FormData(document.getElementById('bookingForm'));

    fetch('add_booking.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.text())
    .then(response => {
        document.getElementById('message').textContent = response;
        loadCalendar(currentMonth, currentYear);
    });
}